/* naGuido.c - dummy interface */

#include <stdio.h>
#include "guido.h"
//#include "test.hpp"

int na_parseGMNFileMode(const char* filename, int mode) {
  int res;
DEBUG(
  printf("parsing file '%s', mode %i ...\n", filename, mode);
)
  gd_init();
  res = gd_parse(filename, mode);
  gd_exit();
  return(res);
  }

int na_parseGMNFile(const char* filename) {
  int res;
DEBUG(
  printf("parsing file '%s' ...\n", filename, mode);
)
  gd_init();
  res = gd_parse(filename, PARSE_MODE_ALL);
  gd_exit();
  return(res);
  }


char na_getTagArgType(int n) {
  return(gd_getTagArgType(n));
  }

char* na_getTagArgName(int n) {
  return(gd_getTagArgName(n));
  }

long int na_getTagArgInt(int n) {
  return(gd_getTagArgInt(n));
  }

T_REAL na_getTagArgFloat(int n) {
  return(gd_getTagArgFloat(n));
  }

char* na_getTagArgUnit(int n) {
  return(gd_getTagArgUnit(n));
  }

char* na_getTagArgStr(int n) {
  return(gd_getTagArgStr(n));
  }



/* -------------------------------------------------
	APPLICATION SPECIFIC SECTIONS:

	the following part has to be adapted for the
	application which is to use the GUIDO parser module
	------------------------------------------------- */

#include "../Gmn2Midi.h"
extern Gmn2Midi* myGmn2Midi;

void na_segmInit() {
	//printf("na_segmInit()\n");
	myGmn2Midi->na_segmInit();
// for debugging only:
//  app->beep();
	}

void na_segmExit() {
	//printf("na_segmExit()\n");
	myGmn2Midi->na_segmExit();
	}

void na_seqInit() {
	//printf("na_seqInit()\n");
	myGmn2Midi->na_seqInit();
	}

void na_seqExit() {
	//printf("na_seqExit()\n");
	myGmn2Midi->na_seqExit();
	}

void na_seqAppendNote(int pc, int oct, int acc, long int durN, long int durD, int dots,
		long int durPosN, long int durPosD){
	//printf("na_seqAppendNote(pc=%i,oct=%i,acc=%i, durN=%li,durD=%li,dots=%i, durPosN=%li,durPosD=%li)\n", pc,oct,acc,durN,durD,dots,durPosN,durPosD);
	myGmn2Midi->na_seqAppendNote(pc,oct,acc,durN,durD,dots,durPosN,durPosD);
	}

void na_chordInit(long int durPosN, long int durPosD) {
  //printf("na_chordInit(durPosN=%li,durPosD=%li)\n", durPosN, durPosD);
  myGmn2Midi->na_chordInit(durPosN,durPosD);
  }

void na_seqAppendChord(int voices, long int durN, long int durD, int dots,
    long int durPosN, long int durPosD) {
	//printf("na_seqAppendChord(voices=%i, durN=%li,durD=%li, dots=%i, durPosN=%li,durPosD=%li)\n", voices,durN,durD,dots,durPosN,durPosD);
	myGmn2Midi->na_seqAppendChord(voices,durN,durD,dots,durPosN,durPosD);
  }


void na_tagStart(char* s, long int no, long int tagno, long int durPosN, long int durPosD) {
	//printf("na_tagStart(s=\"%s\",no=%li,tagno=%li, durPosN=%li,durPosD=%li)\n", s, no, tagno, durPosN,durPosD);
	myGmn2Midi->na_tagStart(s,no,tagno,durPosN,durPosD);
	}

void na_tagEnd(long int tagno, long int durPosN, long int durPosD,
											long int beforeDurPosN, long int beforeDurPosD) {
	//printf("na_tagEnd(tagno=%li, durPosN=%li,durPosD=%li, ", tagno, durPosN, durPosD);
	//printf("beforeDurPosN=%li,beforeDurPosD=%li)\n", beforeDurPosN, beforeDurPosD);
	myGmn2Midi->na_tagEnd(tagno,durPosN,durPosD,beforeDurPosN,beforeDurPosD);
	}


/* obsolete from here ... */
void na_tagIntArg(long int n) {
	//printf("na_tagIntArg(n=%li)\n",n);
	}

void na_tagFloatArg(T_REAL r) {
	//printf("na_tagIntArg(r=%f)\n",r);
	}

void na_tagStrArg(char *s) {
	//printf("na_tagStrArg(s=\"%s\")\n",s);
	}
/* ... to here. */


void na_tagAdd(long int tagno, int nargs) {
  int n;
 	//printf("na_tagAdd(tagno=%li, nargs=%i)\n", tagno, nargs);
  if (nargs > 0) {
    //printf("  tag parameters:\n");
    for (n=1; n<=nargs; n++) {
      //printf("  #%i: na_getTagArgName(%i)=\"%s\"  ", n, n, na_getTagArgName(n));
      switch (na_getTagArgType(n)) {
        case 'i': //printf("na_getTagArgInt(%i)=%li, na_getTagArgUnit(%i)=\"%s\"\n", n, na_getTagArgInt(n), n, na_getTagArgUnit(n));
                  break;
        case 'f': //printf("na_getTagArgFloat(%i)=%lf, na_getTagArgUnit(%i)=\"%s\"\n", n, na_getTagArgFloat(n), n, na_getTagArgUnit(n));
                  break;
        case 's': //printf("na_getTagArgString(%i)=\"%s\"\n", n, na_getTagArgStr(n));
                  break;
        default: //printf("    invalid tag arg type!! na_getTagArgType(%i)=%c\n", n, na_getTagArgType(n));
			break;
        }
      }
    }
  myGmn2Midi->na_tagAdd(tagno,nargs);
	}

void na_parseError(long int lnr, long int cnr, const char *msg) {
	//printf("\nERROR: %s (line %li, char %li)\n", msg, lnr,cnr);
	myGmn2Midi->message                                                                                                                                                                                